import jenkins.model.*
import hudson.security.*

def userId = args[0]

def instance = Jenkins.getInstance()

def realm = new HudsonPrivateSecurityRealm(false)
instance.setSecurityRealm(realm)

println("--> define strategy")
def strategy = new hudson.security.GlobalMatrixAuthorizationStrategy()
def existingUser = instance.securityRealm.allUsers.find {it.id == userId}

if (existingUser) {
    println("--> Jenkins.ADMINISTER - " + userId)

    strategy.add(Jenkins.ADMINISTER, userId)

    instance.setAuthorizationStrategy(strategy)

    instance.save()
}
